package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequest;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestMessage;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestMessages;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequests;

import javax.annotation.Resource;

public class AppointmentRequestDataLayerRepo implements AppointmentRequestDataLayer {

	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(AppointmentRequestDataLayerRepo.class);

	@Resource
	private AppointmentRequestDao dao;

	@Override
	public VARAppointmentRequests fetchAppointmentRequestsByPatient(PatientIdentifiers identifiers, DateFilter filter) {
		LOGGER.debug("Getting AppointmentRequest");
		return dao.getActiveAppointmentRequests(identifiers, filter);
	}

	public VARAppointmentRequest saveAppointmentRequest(VARAppointmentRequest appointmentRequest) {
		LOGGER.debug("Saving AppointmentRequest");
		return dao.saveAppointmentRequest(appointmentRequest);
	}

	public void deleteAppointmentRequest(VARAppointmentRequest appointmentRequest) {
		LOGGER.debug("Deleting AppointmentRequest");
		dao.deleteAppointmentRequest(appointmentRequest);
	}

	@Override
	public VARAppointmentRequest fetchAppointmentRequest(PatientIdentifiers identifiers, String appointmentRequestId) {
		LOGGER.debug("Getting Filtered AppointmentRequests");
		return dao.getActiveAppointmentRequest(identifiers, appointmentRequestId);
	}

    @Override
    public VARAppointmentRequestMessages fetchAppointmentRequestMessages(PatientIdentifiers identifiers, String appointmentRequestId) {
    	LOGGER.debug("Getting AppointmentRequestMessages");
    	return dao.getAppointmentRequestMessagesByAppointmentRequestId(identifiers, appointmentRequestId);
    }

    @Override
    public VARAppointmentRequestMessage saveAppointmentRequestMessage(PatientIdentifiers identifiers, VARAppointmentRequestMessage appointmentRequestMessage, boolean isProvider) {
    	LOGGER.debug("Saving appointmentRequestMessage");

		return dao.saveAppointmentRequestMessage(identifiers, appointmentRequestMessage, isProvider);
    }

    @Override
	public VARAppointmentRequests fetchAppointmentRequests(AppointmentRequestFilter filter) {
		LOGGER.debug("Getting AppointmentRequest");
		return dao.getAppointmentRequests(filter);
	}

	@Override
	public VARAppointmentRequest updateMessageFlag(PatientIdentifiers identifiers, String appointmentRequestId, boolean isProvider) {
		LOGGER.debug("Updating message flag for Appointment Request");
		return dao.updateAppointmentRequestMessageFlag(identifiers, appointmentRequestId, isProvider);
	}

	@Override
	public VARAppointmentRequest markAppointmentRequestIsSeenByProvider(PatientIdentifiers identifiers, String appointmentRequestId) {
		LOGGER.debug("Updating Provider_Seen_Appointment_Request flag for Appointment Request");
		return dao.updateProviderSeenAppointmentRequestFlag(identifiers, appointmentRequestId);
	}

	@Override
	public int getSubmittedRequestCountByApptType(String patientId, DateFilter filter, String apptType, String locationId) {
		LOGGER.debug("Getting submitted Appointment Request count by Appt Type...");
		return dao.getSubmittedRequestCountByApptType(patientId, filter, apptType, locationId);
	}
}
